% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDiffusion.R
\name{plotDiffusion}
\alias{plotDiffusion}
\title{Plot Diffusion Profiles}
\usage{
plotDiffusion(filename, t = 1)
}
\arguments{
\item{filename}{Name of the file that contains the results of a simulated electrochemistry experiment.}

\item{t}{The time for which the diffusion profile is desired.}
}
\value{
Returns a line plot that shows distance from the electrode's surface on the \emph{x}-axis and the concentrations of Ox, Red, and, for an EC or a CE mechanism, Z on the \emph{y}-axis.
}
\description{
Plots a set of diffusion profiles (concentration as a function
of distance from the electrode's surface) for an object
created using an object created with one of the package's
simulation functions: \code{cvSim} for cyclic voltammetry,
\code{lsvSim} for linear sweep voltammetry, \code{caSim} for
chronoamperometry, or \code{ccSim} for chronocoulometry. The
plot includes a default title that gives the time and the
potential for the diffusion profile. Note: this function will
not work with the reduced data file created using
\code{sampleAmpgram}, \code{sampleCoulgram}, or
\code{sampleVoltgram}.
}
\examples{

ex_cv = simulateCV(e.start = 0.25, e.switch = -0.25, e.form = 0,
  x.units = 100, t.units = 1000)
plotDiffusion(ex_cv, t = 0.5)

ex_ca = simulateCA(e.start = 0.25, e.pulse = -0.25, e.form = 0,
  pulses = "double", t.2 = 20, x.units = 100, t.units = 1000)
plotDiffusion(ex_ca, t = 21)
}
