% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mIDR.R
\name{mIDR}
\alias{mIDR}
\title{Estimate meta Irreproducible Discovery Rate (mIDR).}
\usage{
mIDR(x, mu, sigma, rho, p, eps = 0.001, max.ite = 20, n_threads = 1)
}
\arguments{
\item{x}{A numeric matrix with rows representing the number of omic features
and columns representing the number of sample replicates. The numeric values
should be positive and represent significance (not necessarily p-values).}

\item{mu}{Starting value for the mean of the reproducible component
Numeric.}

\item{sigma}{Starting value for the standard deviation of the reproducible
component Numeric.}

\item{rho}{Starting value for the correlation coefficient of the
reproducible component Numeric.}

\item{p}{Starting value for the proportion of the reproducible component
Numeric.}

\item{eps}{Stopping criterion. Iterations stop when the increment of the
log-likelihood is less than "eps" times the log-likelihood.
Defaults to 0.001.}

\item{max.ite}{Maximum number of iterations. The default is 30.}

\item{n_threads}{Number of threads for parallel computing. Numeric. Defaults
to 1.}
}
\value{
Returns a list of two elements:
\describe{
  \item{\strong{idr}}{A numeric vector of the local meta IDR
  for each observation.}
  \item{\strong{IDR}}{A numerical vector of the expected meta IDR
   for observations that are as irreproducible or more
   irreproducible than the given observations.}
}
}
\description{
This function extends the Li et al. (2011) copula mixture model, originally
implemented  in  idr::est.IDR,  to  accommodate  any number  of  replicates.
It  computes  the  local  IDR  for all  pairwise combinations of replicates.
Then it computes a "meta" local IDR score using the formula:
                    1 - (1 - idr_1)*...*(1 - idr_C(r,2)),
where C(r,2) represents the number of all pairwise combinations of scores.
Once the meta local IDR is obtained, the expected IDR scores are obtained
in the same way as in the traditional IDR procedure.
}
\examples{
library(eCV)
set.seed(42)

# Simulate data.
out <- simulate_data(scenario = 1, n_reps = 4, n_features = 1e3)

# Set initial parameter values.
mu <- 2
sigma <- 1.3
rho <- 0.8
p <- 0.7

# Get meta local IDR scores.
midr_out <- mIDR(x = out$sim_data, mu, sigma, rho, p)
\donttest{
library(tidyverse)
out$sim_data \%>\%
  as.data.frame() \%>\%
  mutate(`Meta idr` = midr_out$idr) \%>\%
  ggplot(aes(x = `Rep 1`, y = `Rep 2`, color = `Meta idr`)) +
  geom_point(size = 1) +
 scale_color_gradientn(colors=c("#F4364C", "#D5DADD", "#009CA6" ))+ 
  theme_classic()
}
}
\references{
Q. Li, J. B. Brown, H. Huang, and P. J. Bickel. (2011)
Measuring reproducibility of high-throughput experiments.
Annals of Applied Statistics, Vol. 5, No. 3, 1752-1779.
}
