% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrap_add_cyclic_trajectory.R
\name{add_cyclic_trajectory}
\alias{add_cyclic_trajectory}
\title{Constructs a circular trajectory using the pseudotime values of each cell.}
\usage{
add_cyclic_trajectory(
  dataset,
  pseudotime,
  directed = FALSE,
  do_scale_minmax = TRUE,
  ...
)
}
\arguments{
\item{dataset}{A dataset created by \code{\link[=wrap_data]{wrap_data()}} or \code{\link[=wrap_expression]{wrap_expression()}}}

\item{pseudotime}{A named vector of pseudo times.}

\item{directed}{Whether or not the directionality of the pseudotime is predicted.}

\item{do_scale_minmax}{Whether or not to scale the pseudotime between 0 and 1.
Otherwise, will assume the values are already within that range.}

\item{...}{extra information to be stored in the wrapper.}
}
\value{
A trajectory object
}
\description{
The pseudotime is divided into three equally sized segments, and are placed within a trajectory in the form A -> B -> C -> A
}
\examples{
library(tibble)
dataset <- wrap_data(cell_ids = letters)

pseudotime <- tibble(cell_id = dataset$cell_ids, pseudotime = runif(length(dataset$cell_ids)))
pseudotime
trajectory <- add_cyclic_trajectory(dataset, pseudotime)

# for plotting the result, install dynplot
#- dynplot::plot_graph(trajectory)
}
\keyword{create_trajectory}
