% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynrModel.R, R/dynrCook.R
\name{coef.dynrModel}
\alias{coef.dynrCook}
\alias{coef.dynrModel}
\alias{coef<-}
\alias{coef<-.dynrModel}
\title{Extract fitted parameters from a dynrCook Object}
\usage{
\method{coef}{dynrModel}(object, ...)

coef(object) <- value

\method{coef}{dynrModel}(object) <- value

\method{coef}{dynrCook}(object, ...)
}
\arguments{
\item{object}{The dynrCook object for which the coefficients are desired}

\item{...}{further named arguments, ignored for this method}

\item{value}{values for setting}
}
\value{
A numeric vector of the fitted parameters.
}
\description{
aliases coef.dynrModel coef<- coef<-.dynrModel
}
\examples{
# Create a minimal cooked model called 'cook'
require(dynr)

meas <- prep.measurement(
	values.load=matrix(c(1, 0), 1, 2),
	params.load=matrix(c('fixed', 'fixed'), 1, 2),
	state.names=c("Position","Velocity"),
	obs.names=c("y1"))

ecov <- prep.noise(
	values.latent=diag(c(0, 1), 2),
	params.latent=diag(c('fixed', 'dnoise'), 2),
	values.observed=diag(1.5, 1),
	params.observed=diag('mnoise', 1))

initial <- prep.initial(
	values.inistate=c(0, 1),
	params.inistate=c('inipos', 'fixed'),
	values.inicov=diag(1, 2),
	params.inicov=diag('fixed', 2))

dynamics <- prep.matrixDynamics(
	values.dyn=matrix(c(0, -0.1, 1, -0.2), 2, 2),
	params.dyn=matrix(c('fixed', 'spring', 'fixed', 'friction'), 2, 2),
	isContinuousTime=TRUE)

data(Oscillator)
data <- dynr.data(Oscillator, id="id", time="times", observed="y1")

model <- dynr.model(dynamics=dynamics, measurement=meas,
	noise=ecov, initial=initial, data=data)

\dontrun{
cook <- dynr.cook(model,
	verbose=FALSE, optimization_flag=FALSE, hessian_flag=FALSE)

# Now grab the coef!
coef(cook)
}
}
\seealso{
Other S3 methods \code{\link{logLik.dynrCook}}
}

