% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exactFit.R
\name{exactFit}
\alias{exactFit}
\alias{print.exactFit}
\title{DFI cutoffs for a Test of Exact Fit}
\usage{
exactFit(model, n, plot = FALSE, manual = FALSE, reps = 500)

\method{print}{exactFit}(x, ...)
}
\arguments{
\item{model}{This can either be a \code{\link{lavaan}} object from the \code{\link{cfa}} function,
OR a model statement written in \code{\link{lavaan}} \code{\link{model.syntax}} with standardized loadings.}

\item{n}{If you entered a \code{\link{lavaan}} object for model, leave this blank.
Otherwise, enter your sample size (numeric).}

\item{plot}{Displays distributions of fit indices for each fit index.}

\item{manual}{If you entered a \code{\link{lavaan}} object, keep this set to FALSE.
If you manually entered standardized loadings and sample size, set this to TRUE.}

\item{reps}{(**Do not modify this**): The number of replications used in your simulation. This is set to 500 by default in both the
R package and the corresponding Shiny App (not yet available).}

\item{x}{exactFit object}

\item{...}{other print parameters}
}
\value{
Dynamic fit index (DFI) cutoffs for Chi-Square, SRMR, RMSEA, and CFI.
}
\description{
This function generates DFI cutoffs by treating the data generating model as the true model (using ML estimation).
The default argument is a singular argument: a \code{\link{lavaan}} object from the \code{\link{cfa}} function.
The function can also accommodate manual entry of the model statement and sample size.
}
\examples{
#Lavaan object example (manual=FALSE)
dat <- lavaan::HolzingerSwineford1939
lavmod <- "F1 =~ x1 + x2 + x3
           F2 =~ x4 + x5 + x6
           F3 =~ x7 + x8 + x9"
fit <- lavaan::cfa(lavmod,dat)
\donttest{exactFit(fit)}

#Manual entry example for a sample size of 400 (manual=TRUE)
manmod <- "F1 =~ .602*Y1 + .805*Y2 + .516*Y3 + .415*Y4
           F2 =~ .413*Y5 + -.631*Y6
           F1 ~~ .443*F2
           Y4 ~~ .301*Y5"
\donttest{exactFit(model=manmod,n=400,manual=TRUE)}

}
\author{
Melissa G Wolf & Daniel McNeish

Maintainer: Melissa G Wolf <missgord@gmail.com>
}
