% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fun.R
\name{estpsi}
\alias{estpsi}
\alias{estpsi.rings}
\alias{estpsi.ringscc}
\alias{estpsi.xyLayout}
\alias{estpsi.rpA}
\alias{estpsi.rdat}
\alias{estpsi.data.frame}
\title{Estimate Probability Carcass lands in Searched Area}
\usage{
estpsi(x, ...)

\method{estpsi}{rings}(x, model, extent = "full", nsim = 1000, zrad = 200, ...)

\method{estpsi}{ringscc}(
  x,
  model,
  modnames = NULL,
  extent = "full",
  nsim = 1000,
  zrad = 200,
  ...
)

\method{estpsi}{xyLayout}(x, model, extent = "full", nsim = 1000, zrad = 200, ...)

\method{estpsi}{rpA}(x, model, extent = "full", nsim = 1000, zrad = 200, ...)

\method{estpsi}{rdat}(x, model, extent = "full", nsim = 1000, zrad = 200, ...)

\method{estpsi}{data.frame}(x, model, extent = "full", nsim = 1000, zrad = 200, ...)
}
\arguments{
\item{x}{data \describe{
 \item{\code{rings}}{a formatted site map created from raw data via function
   \code{\link{prepRing}} (or as a component of a list returned by 
   \code{\link{addCarcass}}).}
 \item{\code{ringscc}}{a list of \code{rings} objects, one for each carcass
   class; created from raw data via function \code{\link{prepRing}} (or as a 
   component of a list returned by \code{\link{addCarcass}}).}
 \item{\code{xyLayout}}{formatted site map data derived from (x, y) coordinates
   covering every square meter of searched areas at each turbine; derived from
   the function \code{\link{initLayout}}, when called with \code{xy} data.}
 \item{\code{rpA}}{(intended as an internal function that would rarely be 
   called directly by users) a list of data frames (one for each turbine) 
   giving the fraction of area searched (\code{pinc} at  each distance 
   (\code{r}). \code{rpA} data are embedded in \code{\link[=prepRing]{rings}} 
   objects that are created from site "maps" via \code{\link{prepRing}}.}
 \item{\code{rdat}}{(intended as an internal function that would rarely be 
   called directly by users) list of data frames giving the area searched 
   (\code{"exposure"}), in a 1 meter ring with outer radius \code{"r"} and the 
   number of carcasses found \code{"ncarc"} in each ring, with search class 
   \code{scVar} optional. There is also a summary data frame 
   \code{$rdat[["total"]]} that sums the exposures and carcass counts for all 
   turbines across the site. The \code{$rdat[["total"]]} is the data frame 
   used in fitting the GLMs. \code{rdat} objects are components of the return
   value of \code{\link{prepRing}}}
 \item{\code{data.frame}}{(intended as an internal function that would rarely be 
   called directly by users) a data frame giving the fraction of area searched 
   (\code{pinc} at  each distance (\code{r}).}
}}

\item{...}{ignored}

\item{model}{A fitted \code{dd} model or an array of estimated parameters
(\code{ddSim} object); or, if \code{x} is a \code{ringscc} object, a list
of \code{dd} models (one for each carcass class), or a \code{ddArraycc}
accompanied by a vector of model names to use (one for each carcass class).}

\item{extent}{calculate dwp within searched radius only (\code{"win"}) or
for full complement of carcasses (\code{"full"}), including those that fall
outside the search radius.}

\item{nsim}{number of parametric bootstrap iterations for accounting for
uncertainty in the estimator. Default is \code{nsim = 1000}. Use 
\code{nsim = 0} for the estimate of \code{psi} based on the  MLE of
the given model without accounting for uncertainty.}

\item{zrad}{radius}

\item{modnames}{if \code{x} is a \code{ringscc} object, a vector of names of 
model to use for each carcass class; otherwise, \code{modnames} is ignored.}
}
\value{
A \code{psiHat} object, which is either 1) an array giving the 
 expected fraction  of carcasses lying in the searched area at each turbine 
 with \code{nsim} rows and one column for each turbine + one row for the 
 total; or 2) a list of such arrays, one for each carcass class if \code{x} 
 is a \code{ringscc} object. The uncertainty in the expected fractions is
 characterized by simulation and reflected in the variation in \code{psi}
 values within each column.
}
\description{
Estimated probability that carcass lands in searched area. This
 is an intermediate step in estimating dwp but is also interesting in its own
 right. The estimation involves integrating the modeled carcass distribution 
 (\code{model}) over the  search plots at the turbines. Data for the search 
 plots is stored in the generic argument, \code{x}, which can take any of a
 number of different forms, as described in the \code{Arguments} section (below).
}
