% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/onlinem.R
\name{onlinem}
\alias{onlinem}
\title{Online monitoring}
\usage{
onlinem(
  data,
  size,
  newdata,
  Lc = 50,
  Lr = 30,
  confidence.level = 0.99,
  type = "T2.var",
  covvar = "empirical",
  plot = TRUE,
  var.estimates = FALSE
)
}
\arguments{
\item{data}{dataframe of reference dataset.
For each batch, variables are arranged in lines and columns are time-instants. The different batches are combined in a single dataset through
rbind}

\item{size}{number of variables}

\item{newdata}{dataframe of one or more new batches for monitoring (each with same number of variables and time instants of \code{data}).
Different batches are combined in a single dataset through rbind}

\item{Lc}{length of the coupled vector}

\item{Lr}{length of random vector (Lr<Lc)}

\item{confidence.level}{H0 probability to be consider to define the quantile (default is 0.99)}

\item{type}{"T2.var" for Hotelling chart (default) and "W.var" for Generalized Variance chart}

\item{covvar}{"empirical" for sample covariance of coefficients (default) and "theoretical" for  estimated theoretical covariance}

\item{plot}{TRUE shows the charts plots (default TRUE)}

\item{var.estimates}{TRUE show informations about the VAR modeling phase and the elements for setting T2.var / W.var control charts (default FALSE)}
}
\value{
beyond.limits: returns the time-instants of each batch that the T2.var (or W.var) score are above the control limit

 arl: returns for each new batch the mean number of time-instants before a signal is given by the control chart
     (arl=n/g, where n is the overall number of time-instants and g is the number of time-instants above the control limit)


  time.to.first.detection (TFD): returns for each new batch the first time-instant (the most recently instant) that can be considered
      as a possible signal of process change. TFD is the first point (t*) above the limit followed by two consecutive points above the control limit


 artl: returns the cumulative rate of the overall time-instants (n) until the first three consecutive points are above the control limit.
       The artl is computed using the first of these three points, that is, artl=t*/n

varest: If var.estimates=TRUE, it returns the Lim_T2 vector (or Lim_W vector) of the T2.var (or W.var) control limits to each time-instant;
the T2.var (or W.var) scores for each new batch to each time-instant [(tnew) matrix for the T2.var and (wnew) matrix for the W.var scores];
the number (I) of reference batches; the number (C=size*size) of estimated phis coefficients; the number (Inew) of new batches;
the number (n) of time-instants and the (cov) list including the estimated mean
covariance from the reference batches to each time-instant




#' @examples

# Example 1: Monitoring considering two variables and Inew=5 in control batches

   mydata=simon()

   T2.var.on=onlinem(data=mydata$data,size=2,newdata=mydata$newdata)
    W.var.on=onlinem(data=mydata$data,size=2,type="W.var",newdata=mydata$newdata)


# Example 2: Monitoring considering two variables and Inew=10 in control batches

    B1=matrix(c(-0.3, 0.4, 0.4, 0.5), 2, byrow=TRUE)
    B1new=B1
    mydata2=simon(n=100,I=200,size=2,Inew=10,n1=50,B1=B1,varcov=diag(2),B1new=B1new)
   T2.var.on=onlinem(data=mydata2$data,size=2,newdata=mydata2$newdata, plot=F)
   W.var.on=onlinem(data=mydata2$data,size=2,type="W.var",newdata=mydata2$newdata, plot=F)


 # Example 3: Monitoring considering three variables and Inew=10 out of control batches

   B1=matrix(c(-0.3,0,0.4,0,0.2,0,0,-0.1,0.5),3,byrow=TRUE)
   B1new=matrix(c(0.7,0,0.4,0,0.5,0,0,-0.1,0.5),3,byrow=TRUE)
   mydata3=simon(n=100,I=200,size=3,Inew=10,n1=50,B1=B1,varcov=diag(3),B1new=B1new)
   T2.var.on=onlinem(data=mydata3$data,size=3,newdata=mydata3$newdata, plot=F)
   W.var.on=onlinem(data=mydata3$data,size=3,type="W.var",newdata=mydata3$newdata, plot=F)
}
\description{
Online T2.var and W.var control charts for monitoring batch processes based on VAR model.
This approach is fully described in "Marcondes Filho, D., & Valk, M. (2020). Dynamic VAR Model-Based Control Charts
 for Batch Process Monitoring. European Journal of Operational Research."
}
\details{
The maximum number of variables is five.

All batches must have the same number of time-instants.

This method is based on the use of "coupled vectors (cv)" (for more details, see Marcondes Filho, D., & Valk, M., 2020").

The parameters Lc and Lr define the cv structure.

Considering the new ongoing batch under monitoring:

Lc is the number of elements of cv. (Lc is smaller than the number of time-instants);
Lr is the number of elements in cv randomly chosen from the in control batches in the reference dataset;
Lc-Lr is the number of elements in cv from the last (Lc-Lr) observations of the new ongoing batch.

Default is  Lc= 50 e Lr=30.

The batches in dataset "data" are considered to be in control
}
\seealso{
simon
}
