% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/offlinem.R
\name{offlinem}
\alias{offlinem}
\title{Offline monitoring}
\usage{
offlinem(
  data,
  size,
  newdata = NULL,
  confidence.level = 0.99,
  type = "T2.var",
  covvar = "empirical",
  plot = TRUE,
  var.estimates = FALSE
)
}
\arguments{
\item{data}{dataframe of reference dataset.
For each batch, variables are arranged in lines and columns are time-instants. The different batches are combined in a single dataset through
rbind}

\item{size}{number of variables}

\item{newdata}{dataframe of one or more new batches for monitoring (each with same number of variables and time instants of \code{data}).
Different batches are combined in a single dataset through rbind}

\item{confidence.level}{H0 probability to be consider to define the quantile (default is 0.99)}

\item{type}{"T2.var" for Hotelling chart (default) and "W.var" for Generalized Variance chart}

\item{covvar}{"empirical" for sample covariance of coefficients (default) and "theoretical" for  estimated theoretical covariance}

\item{plot}{TRUE shows the charts plots (default TRUE)}

\item{var.estimates}{TRUE show informations about the VAR modeling phase (default FALSE)}
}
\value{
beyond.limits: returns the batches that the T2.var (or W.var) scores are above the control limit

 LimT2 (or LimW): T2.var (or W.var) control limit

 perc: perc_ref (and perc_new) returns the rate of reference batches (and new batches) above the control limit
       (perc_ref= g_ref/I and perc_new= g_new/Inew, where I (Inew) is the overall number of reference batches (new batches) and g_ref (g_new) is the number of reference batches (new batches) above the control limit)

 arl: arl_ref (and arl_new) returns the mean number of reference batches (and new batches) before a signal is given by the charts
     (arl_ref=1/perc_ref and arl_new=1/perc_new)


 varest: If var.estimates=TRUE, it returns the matrices (vec.phis and vec.phis.new) in which each row contains the estimated VAR(1) phis for each reference batches and new batches, respectively;
 the matrices (vec.cov.theoretical and vec.cov.empirical) with  the  theoretical and empirical estimated phis covariances from the reference batches, respectively;
            the lists (cov.B1 and cov.B1new) of the theoretical estimated phis covariances of the reference and new batches, respectively;
            the number (I) of reference batches; the number (Inew) of new batches; and the number (n) of time-instants
}
\description{
Offline T2.var and W.var control charts for monitoring batch processes based on VAR model.
This approach is fully described in "Marcondes Filho, D., & Valk, M. (2020). Dynamic VAR Model-Based Control Charts
 for Batch Process Monitoring. European Journal of Operational Research."
}
\details{
#' The maximum number of variables is five.

All batches must have the same number of time-instants.

The dataset of batches in "data" are considered to be in control
}
\examples{

# Example 1: Monitoring considering two variables and Inew= 10 in control batches

   mydata=simoff()
   T2.var=offlinem(data=mydata$data,size=2)
   T2.var.new=offlinem(data=mydata$data,size=2,newdata=mydata$newdata)
   W.var=offlinem(data=mydata$data,size=2,type="W.var")
   W.var.new=offlinem(data=mydata$data,size=2,type="W.var",newdata=mydata$newdata)


# Example 2: Monitoring considering three variables and Inew=50 out of control batches

   B1=matrix(c(-0.3,0,0.4,0,0.2,0,0,-0.1,0.5),3,byrow=TRUE)
   B1new=matrix(c(0.7,0,0.4,0,0.5,0,0,-0.1,0.5),3,byrow=TRUE)
   mydata2=simoff(n=100,I=100,size=3,Inew=50,B1,varcov=diag(3),B1new)
   T2.var=offlinem(data=mydata2$data,size=3)
   T2.var.new=offlinem(data=mydata2$data,size=3,newdata=mydata2$newdata)
   W.var=offlinem(data=mydata2$data,size=3,type="W.var")
   W.var.new=offlinem(data=mydata2$data,size=3,type="W.var",newdata=mydata2$newdata)

}
\seealso{
simoff
}
