% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{which_max_nv}
\alias{which_max_nv}
\title{Return Index of (First) Maximum of a Numeric Vector}
\usage{
which_max_nv(x)
}
\arguments{
\item{x}{Numeric vector.}
}
\value{
Integer value.
}
\description{
Written in C++, this function tends to run faster than \code{which.max} for 
large numeric vectors.
}
\details{
For optimal speed, choose the version of this function that matches the 
class of your \code{x}:

\code{\link{which_max_nv}} for numeric vector. \cr
\code{\link{which_max_iv}} for integer vector. \cr
\code{\link{which_max_nm}} for numeric matrix. \cr
\code{\link{which_max_im}} for integer matrix.
}
\examples{
# For long vectors, which_max_nv is faster than which.max
x <- rnorm(100000)
which.max(x) == which_max_nv(x)
benchmark(which.max(x), which_max_nv(x), replications = 500)

# For shorter vectors, which_max_nv is slower than which.max
x <- rnorm(100)
which.max(x) == which_max_nv(x)
benchmark(which.max(x), which_max_nv(x), replications = 10000)

}
