% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dviJoint.R
\name{dviJoint}
\alias{dviJoint}
\title{Joint DVI search}
\usage{
dviJoint(
  dvi,
  assignments = NULL,
  ignoreSex = FALSE,
  disableMutations = FALSE,
  maxAssign = 1e+05,
  numCores = 1,
  cutoff = 0,
  verbose = TRUE,
  progress = verbose
)
}
\arguments{
\item{dvi}{A \code{dviData} object, typically created with \code{\link[=dviData]{dviData()}}.}

\item{assignments}{A data frame containing the assignments to be considered
in the joint analysis. By default, this is automatically generated by
taking all combinations from \code{dvi$pairings}.}

\item{ignoreSex}{A logical, only relevant if \code{dvi$pairings} is NULL, so that
candidate pairings have to be generated.}

\item{disableMutations}{Either TRUE, FALSE (default) or NA. If NA, mutation
modelling is applied only in families where the reference data are
incompatible with the pedigree unless at least one mutation has occurred.}

\item{maxAssign}{A positive integer. If the number of assignments going into
the joint calculation exceeds this, the function will abort with an
informative error message. Default: 1e5.}

\item{numCores}{An integer; the number of cores used in parallelisation.
Default: 1.}

\item{cutoff}{A number; if non-negative, the output table is restricted to
LRs equal to or exceeding this value.}

\item{verbose}{A logical.}

\item{progress}{A logical, indicating if a progress bar should be shown.}
}
\value{
A data frame.
}
\description{
This is a redesign of \code{\link[=jointDVI]{jointDVI()}}, with narrower scope (no preprocessing
steps) and more informative output. The output includes the pairwise GLR
matrix based on the joint table.
}
\examples{
dviJoint(example2)

}
