% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{plot_posterior}
\alias{plot_posterior}
\title{Plot posterior probability distribution and display posterior parameters
for an object of class \code{Counts}}
\usage{
plot_posterior(object, low = 0.025, up = 0.975, xlab, step, ...)
}
\arguments{
\item{object}{object of class \code{Counts}}

\item{low}{1 - right tail posterior probability}

\item{up}{left tail posterior probability}

\item{xlab}{x-axis label. Default to 'n' (no label)}

\item{step}{integer defining the increment for x-axis labels (distance between two consecutive tick marks)}

\item{...}{additional parameters to be passed to \link{curve}}
}
\value{
no return value, called for side effects
}
\description{
Plot posterior probability distribution and display posterior parameters
for an object of class \code{Counts}
}
\examples{
counts <- new_counts(counts = c(20,30), fractions = c(0.075, 0.10))

# default parameters ("dup" algorithm, sampling without replacement, default prior support)
posterior <- compute_posterior(counts)

# plot posterior
plot_posterior(posterior, type = 'l', lwd = 3, col = 'blue3')

}
\references{
Comoglio F, Fracchia L and Rinaldi M (2013) 
Bayesian inference from count data using discrete uniform priors. 
\href{https://journals.plos.org/plosone/article?id=10.1371/journal.pone.0074388}{PLoS ONE 8(10): e74388}
}
\author{
Federico Comoglio
}
