#' Bayesian inference from count data using discrete uniform priors
#' 
#' @name dupiR-package
#' 
#' @description This package allows to infer population sizes using a binomial likelihood 
#' and least informative discrete uniform priors.
#' 
#' @author Federico Comoglio \email{federico.comoglio@@gmail.com}
#' @author Maurizio Rinaldi
#' 
#' @aliases dupiR-package dupiR
#' 
#' @references 
#' 
#' Comoglio F, Fracchia L, Rinaldi M (2013) Bayesian Inference from Count Data 
#' Using Discrete Uniform Priors. PLoS ONE 8(10): e74388
#'
#' @keywords package
#' 
#' @importFrom methods show
#' @importFrom methods is
#' @importFrom methods new
#' @importFrom methods validObject
#' @importFrom graphics abline
#' @importFrom graphics axis
#' @importFrom graphics curve
#' @importFrom graphics legend
#' @importFrom graphics lines
#' @importFrom graphics rect
#' @importFrom stats dgamma
#' @importFrom stats dnbinom
#' @importFrom stats pgamma
#' @importFrom stats qgamma
#' @importFrom utils head
#' @importFrom utils tail
#' @importFrom plotrix addtable2plot
#'
"_PACKAGE"