% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix_evaluation.R
\name{n_eval}
\alias{n_eval}
\title{Evaluate N basis}
\usage{
n_eval(k, xd, x, normalized = TRUE, knot_idx = NULL, N = NULL)
}
\arguments{
\item{k}{Order for the discrete B-spline basis. Must be >= 0.}

\item{xd}{Design points. Must be sorted in increasing order, and have length
at least \code{k+1}.}

\item{x}{Query points. Must be sorted in increasing order.}

\item{normalized}{Should the discrete B-spline basis vectors be normalized to
attain a maximum value of 1 over the design points? The default is \code{TRUE}.}

\item{knot_idx}{Vector of indices, a subset of \code{(k+1):(n-1)} where \code{n = length(xd)}, that indicates which design points should be used as knot
points for the discrete B-splines. Must be sorted in increasing order. The
default is \code{NULL}, which is taken to mean \code{(k+1):(n-1)}.}

\item{N}{Matrix of discrete B-spline evaluations at the design points. The
default is \code{NULL}, which means that this is precomputed before constructing
the matrix of discrete B-spline evaluations at the query points. If \code{N} is
non-\code{NULL}, then the argument \code{normalized} will be ignored (as this would
have only been used to construct N at the design points).}
}
\value{
Sparse matrix of dimension \code{length(x)} by \code{length(knot_idx) + k + 1}.
}
\description{
Evaluates the discrete B-spline basis of a given order, with respect to given
design points, evaluated at arbitrary query points.
}
\details{
The discrete B-spline basis functions of order \eqn{k}, defined with
respect to design points \eqn{x_1 < \ldots < x_n}, are denoted
\eqn{\eta^k_1, \ldots, \eta^k_n}. For a discussion of their properties and
further references, see the help file for \code{\link[=n_mat]{n_mat()}}. The current function
produces a matrix of evaluations of the discrete B-spline basis at an
arbitrary sequence of query points. For each query point \eqn{x}, this
matrix has a corresponding row with entries:
\deqn{
  \eta^k_j(x), \; j = 1, \ldots, n.
  }

Unlike the falling factorial basis, the discrete B-spline basis is not
generally available in closed-form. Therefore, the current function (unlike
\code{\link[=h_eval]{h_eval()}}) will first check if it should precompute the evaluations of the
discrete B-spline basis at the design points. If the argument \code{N} is
non-\code{NULL}, then it will use this as the matrix of evaluations at the
design points; if \code{N} is \code{NULL}, then it will call \code{\link[=n_mat]{n_mat()}} to produce
such a matrix, and will pass to this function the arguments \code{normalized}
and \code{knot_idx} accordingly.

After obtaining the matrix of discrete B-spline evaluations at the design
points, the fast interpolation scheme from \code{\link[=dspline_interp]{dspline_interp()}} is used to
produce evaluations at the query points.
}
\examples{
xd = 1:10 / 10
x = 1:9 / 10 + 0.05
n_mat(2, xd, knot_idx = c(3, 5, 7))
n_eval(2, xd, x, knot_idx = c(3, 5, 7))
}
\seealso{
\code{\link[=n_mat]{n_mat()}} for constructing evaluations of the discrete B-spline
basis at the design points.
}
