% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayes-factor.R
\name{as_bf}
\alias{as_bf}
\title{Convert P-value to Bayes Factor}
\usage{
as_bf(pvalue)
}
\arguments{
\item{pvalue}{P-value.}
}
\value{
Bayes Factor (scalar value).
}
\description{
Convert P-value to Bayes Factor
}
\examples{
\donttest{
library(dsos)
bf_from_pvalue <- as_bf(pvalue = 0.5)
bf_from_pvalue
}

}
\references{
Marsman, M., & Wagenmakers, E. J. (2017).
\emph{Three insights from a Bayesian interpretation of the one-sided P value}.
Educational and Psychological Measurement, 77(3), 529-539.
}
\seealso{
[as_pvalue()] to convert Bayes factor to p-value.

Other bayesian-test: 
\code{\link{as_pvalue}()},
\code{\link{bf_compare}()},
\code{\link{bf_from_os}()}
}
\concept{bayesian-test}
