% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Population.Description.R
\docType{class}
\name{Population.Description-class}
\alias{Population.Description-class}
\title{Class "Population.Description"}
\description{
Class \code{"Population.Description"} is an S4 class containing a
description of the population. It provides methods to generate an
example population.
}
\section{Slots}{

\describe{
\item{\code{N}}{Object of class \code{"numeric"}; number of individuals
in the population (optional).}

\item{\code{density}}{Object of class \code{"Density"}; describes the
population density}

\item{\code{region.name}}{Object of class \code{"character"}; name of
the region in which the population exists.}

\item{\code{strata.names}}{Character vector giving the strata names for the study region.}

\item{\code{covariates}}{Named list with one named entry per individual level covariate.
Cluster sizes can be defined here. Each list entry will either be a data.frame
containing 2 columns, the first the level (level) and the second the probability}

\item{\code{size}}{logical value indicating whether the population occurs in
clusters.
(prob). The cluster size entry in the list must be named 'size'.}

\item{\code{gen.by.N}}{Object of class \code{"logical"}; If \code{TRUE}
N is fixed otherwise it is generated from a Poisson distribution.}
}}

\section{Methods}{

\describe{
 \item{\code{get.N}}{\code{signature=(object = "Population.Description")}:
 returns the value of \code{N}}
 \item{\code{generate.population}}{\code{signature=(object = "Population.Description")}: generates a single realisation of the population.}
}
}

\seealso{
\code{\link{make.population.description}}
}
\keyword{classes}
