% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/num_util_fun.R
\name{is_wholenumber}
\alias{is_wholenumber}
\title{Test for whole numbers (i.e., integers)}
\usage{
is_wholenumber(x, tol = .Machine$double.eps^0.5)
}
\arguments{
\item{x}{Number(s) to test (required, accepts numeric vectors).}

\item{tol}{Numeric tolerance value.
Default: \code{tol = .Machine$double.eps^0.5} 
(see \code{?.Machine} for details).}
}
\description{
\code{is_wholenumber} tests if \code{x} contains only integer numbers.
}
\details{
\code{is_wholenumber} does what the \strong{base} R function \code{is.integer} is \strong{not} designed to do: 

\itemize{ 
  \item \code{is_wholenumber()} returns TRUE or FALSE depending on whether its numeric argument \code{x} is an integer value (i.e., a "whole" number). 

  \item \code{is.integer()} returns TRUE or FALSE depending on whether its argument is of integer type, and FALSE if its argument is a factor.  
}

See the documentation of \code{\link{is.integer}} for definition and details.
}
\examples{
is_wholenumber(1)    # is TRUE
is_wholenumber(1/2)  # is FALSE
x <- seq(1, 2, by = 0.5)
is_wholenumber(x)

# Compare:
is.integer(1+2) 
is_wholenumber(1+2) 

}
\seealso{
\code{\link{is.integer}} function of the R \strong{base} package.

Other numeric functions: 
\code{\link{base2dec}()},
\code{\link{base_digits}},
\code{\link{dec2base}()},
\code{\link{is_equal}()},
\code{\link{num_as_char}()},
\code{\link{num_as_ordinal}()},
\code{\link{num_equal}()}

Other utility functions: 
\code{\link{base2dec}()},
\code{\link{base_digits}},
\code{\link{dec2base}()},
\code{\link{is_equal}()},
\code{\link{is_vect}()},
\code{\link{num_as_char}()},
\code{\link{num_as_ordinal}()},
\code{\link{num_equal}()}
}
\concept{numeric functions}
\concept{utility functions}
