% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/change_data_format_to_longer.R
\name{change_data_format_to_longer}
\alias{change_data_format_to_longer}
\title{Data format changer}
\usage{
change_data_format_to_longer(
  .data,
  pattern_column_markers = "_ratio_of_total_cells",
  unique_name_row_identifier = "filter_image",
  additional_columns = TRUE
)
}
\arguments{
\item{.data}{The markers count dataframe that is coming from the processing of the microscopy data}

\item{pattern_column_markers}{The markers' pattern name to obtain the column with ratios of the markers (it defaults to "_ratio_of_total_cells")}

\item{unique_name_row_identifier}{String that indicates the unique identifier for each image, defaults as "filter_image"}

\item{additional_columns}{columns that can be additionally added to the longer formatted data.frame, "Defaults as c("Treatment", "PID", "Image_number", "Tissue", "Concentration", "DOC")"}
}
\value{
A \code{dataframe}/\code{tibble}.
}
\description{
This function gets the count data data.frame, that has a wider format and it returns a longer-formatted data.frame
}
\details{
Reformat the counts data in longer format
}
\examples{
\donttest{
# Set up relabeling list
list_of_relabeling <- list(
  "PathCellObject" = "onlyDAPIPositve",
  "cCasp3" = "cCASP3",
  "E-Cadherin: cCASP3" = "E-Cadherin and cCASP3",
  "EpCAM_E-Cadherin" = "E-Cadherin",
  "EpCAM_E-Cadherin and cCASP3" = "E-Cadherin and cCASP3"
)

# Load and process example data
bind_data <- data_binding(
  path_to_the_projects_folder = system.file("extdata/to_merge/", package = "drugsens")
)
counts_dataframe <- make_count_dataframe(bind_data)

# Convert to long format
plotting_ready_dataframe <- change_data_format_to_longer(counts_dataframe)
}
}
