% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_multiple_normal.R
\name{utility_multiple_normal}
\alias{utility_multiple_normal}
\title{Utility function for multiple endpoints with normally distributed outcomes.}
\usage{
utility_multiple_normal(
  kappa,
  n2,
  alpha,
  beta,
  Delta1,
  Delta2,
  in1,
  in2,
  sigma1,
  sigma2,
  c2,
  c02,
  c3,
  c03,
  K,
  N,
  S,
  steps1,
  stepm1,
  stepl1,
  b1,
  b2,
  b3,
  fixed,
  rho,
  relaxed,
  rsamp
)
}
\arguments{
\item{kappa}{threshold value for the go/no-go decision rule; vector for both endpoints}

\item{n2}{total sample size for phase II; must be even number}

\item{alpha}{significance level}

\item{beta}{\code{1-beta} power for calculation of sample size for phase III}

\item{Delta1}{assumed true treatment effect given as difference in means for endpoint 1}

\item{Delta2}{assumed true treatment effect given as difference in means for endpoint 2}

\item{in1}{amount of information for \code{Delta1} in terms of sample size}

\item{in2}{amount of information for \code{Delta2} in terms of sample size}

\item{sigma1}{standard deviation of first endpoint}

\item{sigma2}{standard deviation of second endpoint}

\item{c2}{variable per-patient cost for phase II}

\item{c02}{fixed cost for phase II}

\item{c3}{variable per-patient cost for phase III}

\item{c03}{fixed cost for phase III}

\item{K}{constraint on the costs of the program, default: Inf, e.g. no constraint}

\item{N}{constraint on the total expected sample size of the program, default: Inf, e.g. no constraint}

\item{S}{constraint on the expected probability of a successful program, default: -Inf, e.g. no constraint}

\item{steps1}{lower boundary for effect size category \code{"small"} in HR scale, default: 1}

\item{stepm1}{lower boundary for effect size category \code{"medium"} in HR scale = upper boundary for effect size category \code{"small"} in HR scale, default: 0.95}

\item{stepl1}{lower boundary for effect size category \code{"large"} in HR scale = upper boundary for effect size category \code{"medium"} in HR scale, default: 0.85}

\item{b1}{expected gain for effect size category \code{"small"}}

\item{b2}{expected gain for effect size category \code{"medium"}}

\item{b3}{expected gain for effect size category \code{"large"}}

\item{fixed}{choose if true treatment effects are fixed or random, if TRUE \code{Delta1} is used as fixed effect}

\item{rho}{correlation between the two endpoints}

\item{relaxed}{relaxed or strict decision rule}
}
\value{
The output of the function \code{utility_multiple_normal()} is the expected utility of the program.
}
\description{
The utility function calculates the expected utility of our drug development program and is given as gains minus costs and depends on the parameters and the expected probability of a successful program.
The utility is in a further step maximized by the \code{optimal_multiple_normal()} function.
}
\keyword{internal}
