% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_multitrial_binary.R
\name{utility23_binary}
\alias{utility23_binary}
\title{Utility function for multitrial programs deciding between two or three phase III trials for a binary distributed outcome}
\usage{
utility23_binary(
  n2,
  RRgo,
  w,
  p0,
  p11,
  p12,
  in1,
  in2,
  alpha,
  beta,
  c2,
  c3,
  c02,
  c03,
  b1,
  b2,
  b3
)
}
\arguments{
\item{n2}{total sample size for phase II; must be even number}

\item{RRgo}{threshold value for the go/no-go decision rule}

\item{w}{weight for mixture prior distribution}

\item{p0}{assumed true rate of control group}

\item{p11}{assumed true rate of treatment group}

\item{p12}{assumed true rate of treatment group}

\item{in1}{amount of information for \code{p11} in terms of sample size}

\item{in2}{amount of information for \code{p12} in terms of sample size}

\item{alpha}{significance level}

\item{beta}{\code{1-beta} power for calculation of sample size for phase III}

\item{c2}{variable per-patient cost for phase II}

\item{c3}{variable per-patient cost for phase III}

\item{c02}{fixed cost for phase II}

\item{c03}{fixed cost for phase III}

\item{b1}{expected gain for effect size category \code{"small"}}

\item{b2}{expected gain for effect size category \code{"medium"}}

\item{b3}{expected gain for effect size category \code{"large"}}
}
\value{
The output of the function \code{utility23_binary()} is the expected utility of the program depending on whether two or three phase III trials are performed.
}
\description{
The utility function calculates the expected utility of our drug development program and is given as gains minus costs and depends on the parameters and the expected probability of a successful program.
The utility is in further step maximized by the \code{optimal_multitrial_binary()} function.
}
\examples{
\donttest{utility23_binary(n2 = 50, RRgo = 0.8,  w = 0.3, 
                                 alpha = 0.05, beta = 0.1,
                                 p0 = 0.6, p11 =  0.3, p12 = 0.5, 
                                 in1 = 300, in2 = 600, 
                                 c2 = 0.75, c3 = 1, c02 = 100, c03 = 150,
                                 b1 = 1000, b2 = 2000, b3 = 3000)}
}
\keyword{internal}
