% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_multiple_normal.R
\name{Ess_multiple_normal}
\alias{Ess_multiple_normal}
\title{Expected sample size for phase III for multiple endpoints with normally distributed outcomes}
\usage{
Ess_multiple_normal(
  kappa,
  n2,
  alpha,
  beta,
  Delta1,
  Delta2,
  in1,
  in2,
  sigma1,
  sigma2,
  fixed,
  rho,
  rsamp
)
}
\arguments{
\item{kappa}{threshold value for the go/no-go decision rule; vector for both endpoints}

\item{n2}{total sample size for phase II; must be even number}

\item{alpha}{significance level}

\item{beta}{1-beta power for calculation of sample size for phase III}

\item{Delta1}{assumed true treatment effect given as difference in means for endpoint 1}

\item{Delta2}{assumed true treatment effect given as difference in means for endpoint 2}

\item{in1}{amount of information for Delta1 in terms of sample size}

\item{in2}{amount of information for Delta2 in terms of sample size}

\item{sigma1}{standard deviation of first endpoint}

\item{sigma2}{standard deviation of second endpoint}

\item{fixed}{choose if true treatment effects are fixed or random, if TRUE Delta1 is used as fixed effect}

\item{rho}{correlation between the two endpoints}

\item{rsamp}{sample data set for Monte Carlo integration}
}
\value{
the output of the function Ess_multiple_normal is the expected number of participants in phase III
}
\description{
Given phase II results are promising enough to get the "go"-decision to go to phase III this function now calculates the expected sample size for phase III.
The results of this function are necessary for calculating the utility of the program, which is then in a further step maximized by the \code{optimal_multiple_normal()} function
}
\keyword{internal}
