% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drop_detect.R
\name{drop_detect}
\alias{drop_detect}
\title{Detect Instances of Dropout in Data}
\usage{
drop_detect(data)
}
\arguments{
\item{data}{A dataframe in which to detect instances of dropout.}
}
\value{
A dataframe containing the following columns:
\itemize{
\item \strong{drop}: A logical value indicating whether dropout has occurred (\code{TRUE} for dropout, \code{FALSE} otherwise).
\item \strong{drop_index}: The index of the column where dropout occurred (\code{NA} if no dropout).
\item \strong{column}: The name of the column where the dropout occurred (\verb{<NA>} if no dropout).
}
}
\description{
The \code{drop_detect} function detects participants who drop out of the survey by recognizing NA sequences up to the last question of the survey. Additionally, the function provides the column name and index where the dropout occurs.
}
\examples{
\dontrun{
# Example usage with the 'flying' dataframe
detect_result <- drop_detect(flying)
print(detect_result)
}

}
