% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roll.R
\name{roll}
\alias{roll}
\alias{droll}
\alias{proll}
\alias{qroll}
\alias{rroll}
\title{The roll distribution}
\source{
The main algorithm for calculating dice probabilities comes from
\href{https://mathworld.wolfram.com/Dice.html}{MathWorld}.

Symbolic calculations are handled by
\href{https://cran.r-project.org/package=Ryacas}{Ryacas}, and, by extension, by
\href{https://www.yacas.org/}{Yacas}.
}
\usage{
droll(x, roll)

proll(q, roll, lower.tail = TRUE)

qroll(p, roll, lower.tail = TRUE)

rroll(n, roll)
}
\arguments{
\item{x}{A numeric vector of outcomes.}

\item{roll}{A roll expression (e.g., \code{2 * d6 + 5}) or a data frame returned
by \code{\link[=r]{r()}}.}

\item{q}{A numeric vector of outcomes.}

\item{lower.tail}{Whether to calculate \code{P[X <= x]} or \code{P[X > x]}.}

\item{p}{A numeric vector of probabilities.}

\item{n}{Number of random deviates to return.}
}
\value{
A numeric vector.
}
\description{
Density, distribution function, quantile function, and random generation for
the discrete distribution described by a roll expression. See below for more
details.
}
\details{
Given a roll expression (i.e., an arithmetic expression involving dice),
\code{\link[=r]{r()}} calculates the complete distribution of the outcomes. This is possible
because the distribution is discrete and has a finite number of outcomes.

From this distribution, \code{\link[=droll]{droll()}} returns the density, \code{\link[=proll]{proll()}} returns the
distribution function, \code{\link[=qroll]{qroll()}} returns the quantile function, and
\code{\link[=rroll]{rroll()}} generates random deviates. They mirror functions from the
\link{Distributions} family.

For more details on roll expressions, see \code{\link[=r]{r()}} and the \link{Dice} S4 class.
}
\examples{
set.seed(42)

# Density of 2d6 + 5
droll(12, 2 * d6 + 5)

# Distribution function of 2d6 + 5
proll(12, 2 * d6 + 5)

# Quantile function of 2d6 + 5
qroll(0.5, 2 * d6 + 5)

# Roll 2d6 + 5 (generate random deviate)
rroll(1, 2 * d6 + 5)
}
\seealso{
\code{\link[=r]{r()}}, \link{Dice}, \link{roll-plot}.
}
