% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{roll-plot}
\alias{roll-plot}
\alias{droll_plot}
\alias{proll_plot}
\alias{qroll_plot}
\alias{rroll_plot}
\title{Plot the roll distribution}
\usage{
droll_plot(roll, ...)

proll_plot(roll, lower.tail = TRUE, ...)

qroll_plot(roll, lower.tail = TRUE, ...)

rroll_plot(n, roll, ...)
}
\arguments{
\item{roll}{A roll expression (e.g., \code{2 * d6 + 5}) or a data frame returned
by \code{\link[=r]{r()}}.}

\item{...}{Other arguments passed on to plotting functions
(\code{\link[graphics:barplot]{graphics::barplot()}} or \code{\link[ggplot2:qplot]{ggplot2::qplot()}} if available).}

\item{lower.tail}{Whether to calculate \code{P[X <= x]} or \code{P[X > x]}.}

\item{n}{Number of random deviates to return.}
}
\value{
For \code{\link[=droll_plot]{droll_plot()}}, \code{\link[=proll_plot]{proll_plot()}}, and \code{\link[=qroll_plot]{qroll_plot()}} a bar plot.
For \code{\link[=rroll_plot]{rroll_plot()}} a histogram.
}
\description{
Plot density, distribution function, quantile function, and random generation
for the discrete distribution described by a roll expression. See below for
more details.
}
\details{
Given a roll expression (i.e., an arithmetic expression involving dice),
\code{\link[=r]{r()}} calculates the complete distribution of the outcomes. This is possible
because the distribution is discrete and has a finite number of outcomes.

From this distribution, \code{\link[=droll_plot]{droll_plot()}} plots the density, \code{\link[=proll_plot]{proll_plot()}}
plots the distribution function, \code{\link[=qroll_plot]{qroll_plot()}} plots the quantile function,
and \code{\link[=rroll_plot]{rroll_plot()}} plots random deviates.

For more information, see the generating functions: \link{roll}.
}
\examples{
set.seed(42)

# Density of 2d6 + 5
droll_plot(2 * d6 + 5)

# Distribution function of 2d6 + 5
proll_plot(2 * d6 + 5)

# Quantile function of 2d6 + 5
qroll_plot(2 * d6 + 5)

# Roll 2d6 + 5
rroll_plot(1000, 2 * d6 + 5)
}
\seealso{
\code{\link[graphics:barplot]{graphics::barplot()}}, \code{\link[ggplot2:qplot]{ggplot2::qplot()}}, \code{\link[=d]{d()}}, \link{roll}
}
