% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allgenerics.R
\name{getDistribution}
\alias{getDistribution}
\title{Distributions of the drifting Markov Model}
\usage{
getDistribution(x, pos, all.pos = FALSE, internal = FALSE, ncpu = 2)
}
\arguments{
\item{x}{An object for which the distributions of the DMM can be computed.}

\item{pos}{A positive integer giving the position along the sequence on which the distribution of the DMM should be computed}

\item{all.pos}{`FALSE` (evaluation at position index) ; `TRUE` (evaluation for all position indices)}

\item{internal}{`FALSE` (default) ; `TRUE` (for internal use of the \link[drimmR]{distributions} function)}

\item{ncpu}{Default=2. Represents the number of cores used to parallelized computation. If ncpu=-1, then it uses all available cores.}
}
\value{
A vector or matrix of distribution probabilities
}
\description{
Generic function evaluating the distribution of a model \code{x} at a given position \code{pos} or at every position \code{all.pos}
}
\details{
Distribution at position l is evaluated by \eqn{\mu_{l} =\mu_0 \prod_{t=k}^{l} \ \pi_{\frac{t}{n}}}, \eqn{\forall l \ge k, k \in N^*} order of the DMM
}
\references{
\insertRef{BaVe2018}{drimmR}
\insertRef{Ver08}{drimmR}
}
\author{
Alexandre Seiller
}
