% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{availability}
\alias{availability}
\title{Availability function}
\usage{
availability(
  x,
  k1 = 0L,
  k2,
  upstates,
  output_file = NULL,
  plot = FALSE,
  ncpu = 2
)
}
\arguments{
\item{x}{An object of class \code{dmm}}

\item{k1}{Start position (default value=0):  a positive integer giving the start position along the sequence from which the availabilities of the DMM should be computed, such that \code{k1}<\code{k2}}

\item{k2}{End position :  a positive integer giving the end position along the sequence until which the availabilities of the DMM should be computed, such that \code{k2}>\code{k1}}

\item{upstates}{Character vector giving the subset of operational states U.}

\item{output_file}{(Optional) A file containing matrix of availability probabilities (e.g, "C:/.../AVAL.txt")}

\item{plot}{\code{FALSE} (default); \code{TRUE} (display a figure plot of availability probabilities by position)}

\item{ncpu}{Default=2. Represents the number of cores used to parallelized computation. If ncpu=-1, then it uses all available cores.}
}
\value{
A vector of length k+1 giving the values of the availability for the period \eqn{[0 \ldots k]}
}
\description{
The pointwise (or instantaneous) availability of a system \eqn{S_{ystem}} at time \eqn{k \in N} is the probability
that the system is operational at time k (independently of the fact that the system has failed or not
in \eqn{[0; k)}).
}
\details{
Consider a system (or a component) System whose possible states during its evolution in time are
\eqn{E = \{1 \ldots s \}}. Denote by \eqn{U = \{1 \ldots s_1 \}} the subset of operational states of the system (the upstates) and by \eqn{D =\{s_{1}+1 \ldots s \}} the subset of failure states (the down states), with 0 < s1 < s(obviously, \eqn{E = U \cup D and U \cap D = \emptyset, U \neq \emptyset, D \neq \emptyset}). One can think of the states of U as
different operating modes or performance levels of the system, whereas the states of D can be seen as failures of the systems with different modes.
}
\examples{
data(lambda, package = "drimmR")
length(lambda) <- 1000
dmm <- fitdmm(lambda, 1, 1, c('a','c','g','t'), init.estim = "freq",
 fit.method="sum")
k1 <- 1
k2 <- 200
upstates <- c("c","t")  # vector of working states
getA <- availability(dmm,k1,k2,upstates,plot=TRUE)
}
\references{
\insertRef{BaVe2018}{drimmR}
}
\seealso{
\link[drimmR]{fitdmm}, \link[drimmR]{getTransitionMatrix}, \link[drimmR]{reliability}, \link[drimmR]{maintainability}
}
\author{
Alexandre Seiller
}
