% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logistic2.R
\name{logistic2_gradient}
\alias{logistic2_gradient}
\alias{logistic2_hessian}
\alias{logistic2_gradient_hessian}
\title{2-parameter logistic function gradient and Hessian}
\usage{
logistic2_gradient(x, theta, delta)

logistic2_hessian(x, theta, delta)

logistic2_gradient_hessian(x, theta, delta)
}
\arguments{
\item{x}{numeric vector at which the function is to be evaluated.}

\item{theta}{numeric vector with the two parameters in the form
\code{c(eta, phi)}.}

\item{delta}{value of delta parameter (either 1 or -1).}
}
\value{
Gradient or Hessian evaluated at the specified point.
}
\description{
Evaluate at a particular set of parameters the gradient and Hessian of the
2-parameter logistic function.
}
\details{
The 2-parameter logistic function \verb{f(x; theta)} is defined here as

\verb{g(x; theta) = 1 / (1 + exp(-eta * (x - phi)))}
\verb{f(x; theta) = alpha + delta g(x; theta)}

where \code{theta = c(alpha, delta, eta, phi)} and \code{eta > 0}. Only \code{eta} and \code{phi}
are free to vary (therefore the name) while vector \code{c(alpha, delta)} is
constrained to be either \code{c(0, 1)} (monotonically increasing curve) or
\code{c(1, -1)} (monotonically decreasing curve).
}
