% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_stats.R
\name{srs_stat}
\alias{srs_stat}
\title{Sum-robust-sum (SRS) test statistic to identify dragon kings (DKs)}
\usage{
srs_stat(vals, r, m)
}
\arguments{
\item{vals}{numeric vector with at least 3 elements}

\item{r}{integer indicating number of DKs in \code{vals}}

\item{m}{pre-specified maximum number of DKs in \code{vals}}
}
\value{
SRS test statistic
}
\description{
\code{srs_stat} calculates the SRS test statistic to determine whether
there is significant support for the existence of \code{r} DKs in
\code{vals}. This test provides robustness to denominator masking.
}
\examples{
# generate a numeric vector with DKs
temp <- c(rexp(100),   # exponentially distributed RV
          15, 15, 15)  # DK elements

# calculate test statistic for DKs
srs_stat(temp, r = 2, m = 3)
}
\references{
Wheatley S, Sornette D (2015). Multiple outlier detection in samples with exponential & pareto tails: Redeeming the inward approach & detecting dragon kings. Swiss Finance Institute Research Paper Series No. 15-28. <doi:10.2139/ssrn.2645709>

Iglewicz B, Martinez J (1982). Outlier detection using robust measures of scale. \emph{J Stat Comput Simul}, \strong{15}(4): 285-93. <doi:10.1080/00949658208810595>
}
