% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/packing.R
\name{packing}
\alias{packing}
\title{Arrange data to distribute small values}
\usage{
packing(.data, value, level = NULL)
}
\arguments{
\item{.data}{A data frame, data frame extension (e.g. a tibble), or a lazy data frame (e.g. from dbplyr or dtplyr).}

\item{value}{A .data field which contains values to distribute}

\item{level}{A .data grouping field for distribution}
}
\value{
An object of the same type as .data.
}
\description{
Arrange data to distribute small values further apart from each other
}
\examples{
# Create an example
n <- 20
df <- dplyr::tibble(
 lvl1 = sample(LETTERS[1:5], n, TRUE),
 lvl2 = sample(LETTERS[6:24], n, TRUE),
 value = sample(1:20, n, TRUE)
 )

# Arrange all values
packing(df, value)

# Arrange values within values
packing(df, value, lvl1)
}
