% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lab.R
\name{lab}
\alias{lab}
\title{Create object lab}
\usage{
lab(
  file,
  id,
  age,
  sex,
  normal,
  abnormal,
  is_post = T,
  name_to_find = "LBNRIND"
)
}
\arguments{
\item{file}{A character scalar. Path to the laboratory's reference in the excel table.}

\item{id}{A column name of the subject id in the dataset, without quotes.}

\item{age}{A column name of the subject age in the dataset, without quotes.}

\item{sex}{A column name of the subject sex in the dataset, without quotes.}

\item{normal}{A normal estimate, for example, "NORMAL".}

\item{abnormal}{An abnormal estimate, for example, "ABNORMAL".}

\item{is_post}{A logical scalar, default is TRUE. True is postfix, otherwise, prefix.}

\item{name_to_find}{A character scalar. For search prefixes or postfixes, default is "LBNRIND".}
}
\value{
The object lab.
}
\description{
Create object lab
}
\examples{
obj_lab <- lab("lab_refer.xlsx", ID, AGE, SEX, 1, 2)
obj_lab <- lab("lab_refer.xlsx", ID, AGE, SEX, "NORMAL", "ABNORMAL")
obj_lab <- lab("lab_refer.xlsx", ID, AGE, SEX, "norm", "no", FALSE)
}
