% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_dllm.R
\name{plot.dllm}
\alias{plot.dllm}
\title{Plot a Fitted Dynamic Local Level Model}
\usage{
\method{plot}{dllm}(
  x,
  type = c("smoother", "filter"),
  plot_data = TRUE,
  obs_cols = NULL,
  obs_colors = NULL,
  filter_colors = NULL,
  smoother_colors = NULL,
  conf.int = FALSE,
  sig.level = 0.95,
  ...
)
}
\arguments{
\item{x}{An object of class \code{dllm}, as returned by \code{\link[dlm]{dlm}}.}

\item{type}{Character; one of \code{"smoother"} or \code{"filter"} (default: \code{"smoother"}).
Specifies which fitted curves to display.}

\item{plot_data}{Logical; if \code{TRUE} (default) the observed data points are plotted.}

\item{obs_cols}{Character; an optional argument specifying the variables to be plotted. If \code{NULL},
plot all variables.}

\item{obs_colors}{Optional character vector specifying custom colors for observed data.
If not supplied, a default palette is used.}

\item{filter_colors}{Optional character vector specifying custom colors for filtered curves.
If not supplied, a default palette is used.}

\item{smoother_colors}{Optional character vector specifying custom colors for smoothed curves.
If not supplied, a default palette is used.}

\item{conf.int}{Logical; if \code{TRUE}, plot confidence intervals with the given sig.level.}

\item{sig.level}{Numeric; significance level for confidence intervals (default: 0.95).}

\item{...}{Additional graphical parameters to pass to the underlying plotting functions.}
}
\value{
This function produces a plot of the fitted DLM and returns \code{NULL} invisibly.
}
\description{
Produces a plot for an object of class \code{dllm} (typically created by \code{dllm}).
The function displays the observed data along with the fitted curves computed using filtered and/or
smoothed state estimates.
}
