% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dlvs.R
\name{dlvs}
\alias{dlvs}
\title{Title Do Bayesian variable selection via penalized credible region}
\usage{
dlvs(dlresult)
}
\arguments{
\item{dlresult}{Posterior samples of beta. A large matrix (nmc/thin)*p}
}
\value{
\item{betatil}{Variable selection result of beta, a p*1 vector. Most of the values shrinks to 0}
}
\description{
This is a function using the algorithm doing variable selection via penalized credible
interval proposed by Bondell et al. (2012). The computation of the proposed sequence is
doing matrix computing and using existing LASSO software.
}
\examples{
{
p=30
n=5
#generate x
x=matrix(rnorm(n*p),nrow=n)
#generate beta
beta=c(rep(0,10),runif(n=5,min=-1,max=1),rep(0,10),runif(n=5,min=-1,max=1))
#generate y
y=x\%*\%beta+rnorm(n)
hyper=dlhyper(x,y)
dlresult=dl(x,y,hyper=hyper)
dlvs(dlresult)
}
}
