% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bouts_helpers.R
\name{rmixexp}
\alias{rmixexp}
\title{Generate samples from a mixture of exponential distributions}
\usage{
rmixexp(n, p, lambdas)
}
\arguments{
\item{n}{integer output sample size.}

\item{p}{numeric probabilities for processes generating the output
mixture sample.}

\item{lambdas}{numeric \code{lambda} (rate) for each process.}
}
\value{
vector of samples.
}
\description{
\code{rmixexp} uses a special definition for the probabilities
\code{p_i} to generate random samples from a mixed Poisson distribution
with known parameters for each process.  In the two-process case,
\code{p} represents the proportion of "fast" to "slow" events in the
mixture.  In the three-process case, \code{p_0} represents the
proportion of "fast" to "slow" events, and \code{p_1} represents the
proportion of "slow" to "slow" *and* "very slow" events.
}
\examples{
## Draw samples from a mixture where the first process occurs with
## p < 0.7, and the second process occurs with the remaining
## probability.
p <- 0.7
lda <- c(0.05, 0.005)
(rndprocs2 <- rmixexp(1000, p, lda))

## 3-process
p_f <- 0.6    # fast to slow
p_svs <- 0.7  # prop of slow to (slow + very slow) procs
p_true <- c(p_f, p_svs)
lda_true <- c(0.05, 0.01, 8e-4)
(rndprocs3 <- rmixexp(1000, p_true, lda_true))
}
