% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllMethod.R
\name{labelBouts,numeric-method}
\alias{labelBouts,numeric-method}
\alias{labelBouts}
\alias{labelBouts,Bouts-method}
\title{Label each vector element or matrix row with bout membership number}
\usage{
\S4method{labelBouts}{numeric}(obj, becs, bec.method = c("standard", "seq.diff"))

\S4method{labelBouts}{Bouts}(obj, becs, bec.method = c("standard", "seq.diff"))
}
\arguments{
\item{obj}{Object of class \code{\link{Bouts}} object, or numeric
vector or matrix with independent data modelled as a Poisson
process mixture.}

\item{becs}{numeric vector or matrix with values for the bout ending
criterion which should be compared against the values in x for
identifying the bouts.  It needs to have the same dimensions as
\code{x} to allow for situations where \code{bec} is within
\code{x}.}

\item{bec.method}{character: method used for calculating the
frequencies: \dQuote{standard} simply uses x, while
\dQuote{seq.diff} uses the sequential differences method.}
}
\value{
\code{labelBouts} returns a numeric vector sequentially
    labelling each row or element of \var{x}, which associates it with
    a particular bout. \code{unLogit} and \code{logit} return a numeric
    vector with the (un)transformed arguments.
}
\description{
Identify which bout an observation belongs to.
}
\section{Methods (by class)}{
\itemize{
\item \code{numeric}: Label data on vector or matrix objects.

\item \code{Bouts}: Label data on \code{\link{Bouts}} object
}}

\examples{
## Run example to retrieve random samples for two- and three-process
## Poisson mixtures with known parameters as 'Bouts' objects
## ('xbouts2', and 'xbouts3'), as well as starting values from
## broken-stick model ('startval2' and 'startval3')
utils::example("boutinit", package="diveMove", ask=FALSE)

## 2-process
opts0 <- list(method="L-BFGS-B", lower=c(-2, -5, -10))
opts1 <- list(method="L-BFGS-B", lower=c(1e-1, 1e-3, 1e-6))
bouts2.fit <- fitMLEbouts(xbouts2, start=startval2, optim_opts0=opts0,
                          optim_opts1=opts1)
bec2 <- bec(bouts2.fit)
## labelBouts() expects its second argument to have the same
## dimensions as the data
labelBouts(xbouts2, becs=rep(bec2, length(xbouts2@x)))
}
\keyword{manip}
\keyword{methods}
\keyword{models}
