% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllMethod.R
\name{extractDive,TDR,numeric,numeric-method}
\alias{extractDive,TDR,numeric,numeric-method}
\alias{extractDive}
\alias{extractDive,TDRcalibrate,numeric,missing-method}
\title{Extract Dives from "TDR" or "TDRcalibrate" Objects}
\usage{
\S4method{extractDive}{TDR,numeric,numeric}(obj, diveNo, id)

\S4method{extractDive}{TDRcalibrate,numeric,missing}(obj, diveNo)
}
\arguments{
\item{obj}{\code{\link{TDR}} object.}

\item{diveNo}{numeric vector or scalar with dive numbers to
extract. Duplicates are ignored.}

\item{id}{numeric vector or scalar of dive numbers from where
\code{diveNo} should be chosen.}
}
\value{
An object of class \code{\link{TDR}} or \code{\link{TDRspeed}}.
}
\description{
Extract data corresponding to a particular dive(s), referred to by
number.
}
\section{Methods (by class)}{
\itemize{
\item \code{obj = TDR,diveNo = numeric,id = numeric}: Extract data on TDR object

\item \code{obj = TDRcalibrate,diveNo = numeric,id = missing}: Extract data on TDRcalibrate object
}}

\examples{
\donttest{## Too long for checks
## Continuing the Example from '?calibrateDepth':
utils::example("calibrateDepth", package="diveMove",
               ask=FALSE, echo=FALSE, run.donttest=TRUE)
dcalib		# the 'TDRcalibrate' that was created

diveX <- extractDive(divesTDR, 9, getDAct(dcalib, "dive.id"))
plotTDR(diveX)

diveX <- extractDive(dcalib, 5:10)
plotTDR(diveX)

}
}
\author{
Sebastian P. Luque \email{spluque@gmail.com}
}
\keyword{methods}
