% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rightparetolognormal.R
\name{rightparetolognormal_plt}
\alias{rightparetolognormal_plt}
\title{Right-Pareto Lognormal coefficients of power-law transformed Right-Pareto Lognormal}
\usage{
rightparetolognormal_plt(
  shape2 = 1.5,
  meanlog = -0.5,
  sdlog = 0.5,
  a = 1,
  b = 1,
  inv = FALSE
)
}
\arguments{
\item{shape2, meanlog, sdlog}{Shapes, mean and variance of the Right-Pareto Lognormal distribution respectively.}

\item{a, b}{constant and power of power-law transformation, defaults to 1 and 1 respectively.}

\item{inv}{logical indicating whether coefficients of the outcome variable of the power-law transformation should be returned (FALSE) or whether coefficients of the input variable being power-law transformed should be returned (TRUE). Defaults to FALSE.}
}
\value{
Returns a named list containing
\describe{
\item{coefficients}{Named vector of coefficients}
}

 ## Comparing probabilites of power-law transformed transformed variables
 prightparetolognormal(3, shape2 = 3, meanlog = -0.5, sdlog = 0.5)
 coeff = rightparetolognormal_plt( shape2 = 3, meanlog = -0.5, sdlog = 0.5,a=5,b=7)$coefficients
 prightparetolognormal(5*3^7,shape2=coeff[["shape2"]],meanlog=coeff[["meanlog"]],sdlog=coeff[["sdlog"]])

 prightparetolognormal(5*0.9^7,shape2 = 3, meanlog = -0.5, sdlog = 0.5)
 coeff = rightparetolognormal_plt(shape2 = 3, meanlog = -0.5, sdlog = 0.5,a=5,b=7, inv=TRUE)$coefficients
 prightparetolognormal(0.9,shape2=coeff[["shape2"]],meanlog=coeff[["meanlog"]],sdlog=coeff[["sdlog"]])
}
\description{
Coefficients of a power-law transformed Right-Pareto Lognormal distribution
}
\details{
If the random variable y is Right-Pareto Lognormal distributed with mean meanlog and standard deviation sdlog, then the power-law transformed variable

 \deqn{ y = ax^b }

 is Right-Pareto Lognormal distributed with \eqn{ \frac{meanlog-log(a)}{b}, \frac{sdlog}{b}, shape2*b }.
}
