% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lefttparetolognormal.R
\name{leftparetolognormal_plt}
\alias{leftparetolognormal_plt}
\title{Left-Pareto Lognormal coefficients of power-law transformed Left-Pareto Lognormal}
\usage{
leftparetolognormal_plt(
  shape1 = 1.5,
  meanlog = -0.5,
  sdlog = 0.5,
  a = 1,
  b = 1,
  inv = FALSE
)
}
\arguments{
\item{shape1, meanlog, sdlog}{Shapes, mean and variance of the Left-Pareto Lognormal distribution respectively.}

\item{a, b}{constant and power of power-law transformation, defaults to 1 and 1 respectively.}

\item{inv}{logical indicating whether coefficients of the outcome variable of the power-law transformation should be returned (FALSE) or whether coefficients of the input variable being power-law transformed should be returned (TRUE). Defaults to FALSE.}
}
\value{
Returns a named list containing
\describe{
\item{coefficients}{Named vector of coefficients}
}
}
\description{
Coefficients of a power-law transformed Left-Pareto Lognormal distribution
}
\details{
If the random variable y is Left-Pareto Lognormal distributed with mean meanlog and standard deviation sdlog, then the power-law transformed variable

 \deqn{ y = ax^b }

 is Left-Pareto Lognormal distributed with \eqn{ shape1*b, \frac{meanlog-log(a)}{b}, \frac{sdlog}{b} }.
}
\examples{

## Comparing probabilites of power-law transformed transformed variables
pleftparetolognormal(3, shape1 = 1.5, meanlog = -0.5, sdlog = 0.5)
coeff <- leftparetolognormal_plt(shape1 = 1.5, meanlog = -0.5, sdlog = 0.5,
a = 5, b = 7)$coefficients
pleftparetolognormal(5 * 3^7, shape1 = coeff[["shape1"]], meanlog = coeff[["meanlog"]],
sdlog = coeff[["sdlog"]])

pleftparetolognormal(5 * 0.9^7, shape1 = 1.5, meanlog = -0.5, sdlog = 0.5)
coeff <- leftparetolognormal_plt(shape1 = 1.5, meanlog = -0.5, sdlog = 0.5, a = 5, b = 7,
inv = TRUE)$coefficients
pleftparetolognormal(0.9, shape1 = coeff[["shape1"]], meanlog = coeff[["meanlog"]],
 sdlog = coeff[["sdlog"]])
}
