validate_args_distfreereg_formula <-
  function(test_mean, data, method, method_args, override, control,
           verbose, extra_arg_list){
    stopifnot(is(test_mean, "formula"))

    validate_extra_arg_list(extra_arg_list, "distfreereg.formula()")
    
    validate_single_response_term(form = test_mean)
    strict_match(arg = method, choices = valid_model_methods())
    
    # if(identical(method, "nls") && !is.null(theta_init) && is.null(names(theta_init)))
    #   stop("theta_init must be a named vector when method is 'nls'")
    
    if(!is.data.frame(data)) stop("'data' must be a data frame")
    n <- nrow(data)
    if(n == 0) stop("'data' must have at least one row")
    
    if(!is.null(method_args) && !is.list(method_args))
      stop("method_args must be a list")

    if(!is.null(override[["theta_hat"]]))
      stop("distfreereg.formula() argument 'override' cannot have 'theta_hat' element")
  }
