get_n_single <- function(x){
  if(!is.null(x)){
    if(is.numeric(x)){
      output <- nrow(as.matrix(x))
    } else {
      if(is.data.frame(x)){
        output <- nrow(x)
      } else {
        if(isModel(x)){
          output <- length(fitted(x))
        } else {
          if(is.function(x) || is(x, "formula")){
            output <- NULL
          } else {
            stop("Invalid input to get_n_single(): ", class(x))
          }
        }
      }
    }
  } else {
    output <- NULL
  }
  return(output)
}
