# Calculating res_order using column-wise ordering should refer to data argument
# rather than X matrix formed by, e.g., lm(). This is done by sneaking a 'data'
# element to distfreereg.default() via the 'control' argument.
define_data_for_res_order <- function(test_mean, data, ordering, override, control){
  if(is.null(override[["res_order"]]) && (identical(ordering, "natural") || is.list(ordering))){
    if(is.null(control)){
      control <- list()
    } else {
      stopifnot(is.list(control))
    }
    data_for_ordering <- data
    data_for_ordering[[get_response(test_mean)]] <- NULL
    data_for_ordering[["(weights)"]] <- NULL
    control[["data"]] <- data_for_ordering
  }
  return(control)
}
