get_n <- function(n = NULL, ...){
  all_n <- c(n = n, lapply(list(...), get_n_single))
  all_n <- unlist(all_n[!vapply(all_n, is.null, TRUE)])
  unique_n <- unique(all_n)
  stopifnot("get_n(): No covariates supplied" = length(unique_n) > 0)
  if(length(unique_n) > 1){
    stop("All sets of covariates must have the same number of observations:\n- ",
         paste(names(all_n), all_n, collapse = "\n- ", sep = ": "))
  }
  return(unique_n)
}
