get_cov.nls <- function(m, verbose){
  w <- weights(m)
  if(isTRUE(verbose)) message("Extracting covariance structure from nls object...")
  if(is.null(w)){
    covariance <- list(SqrtSigma = sigma(m))
  } else {
    covariance <- list(SqrtSigma = sigma(m)/sqrt(w))
  }
  return(covariance)
}
