% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dissCqN-fun.R
\name{netShared}
\alias{netShared}
\title{Networks of Shared Species}
\usage{
netShared(net, pairwise = TRUE, compare.sub = NULL)
}
\arguments{
\item{net}{A list of two or more networks to compare, supplied as matrices.}

\item{pairwise}{Logical, whether to compare networks pairwise (default),
rather than considering species shared across multiple networks.}

\item{compare.sub}{Subsets of networks to compare pairwise. These should be
supplied as a list of two sets of network names or indices. If only one set
is supplied, this is compared to all other networks in \code{net}. If more than
two sets are supplied, only the first two are used.}
}
\value{
A list of networks of shared species. If comparing pairwise, this
will be of length \emph{n1} * \emph{n2} * 2 (with \emph{n1} and \emph{n2} being the numbers of
networks in each set), or if considering multiple networks, the length of
the original list.
}
\description{
Generate interaction networks comprising only the shared species
across two or more networks.
}
\note{
If comparing networks pairwise, and subsets are not specified, the
output will contain network self-comparisons (redundancy).
}
