% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{dip3}
\alias{dip3}
\title{Dissolution data of two different capsule formulations}
\format{
A data frame with 24 observations and 6 variables:
\describe{
  \item{cap}{Factor with levels \code{1} to \code{12} representing individual
    capsules}
  \item{batch}{Factor with levels \code{white} and \code{blue} representing
    the colours of two different capsule formulations}
  \item{type}{Factor with levels \code{ref} (Reference) and \code{test}
    (Test)}
  \item{x.15}{Numeric of the \% release at the 15 minutes testing point}
  \item{x.20}{Numeric of the \% release at the 20 minutes testing point}
  \item{x.25}{Numeric of the \% release at the 25 minutes testing point}
}
}
\source{
See reference: Example data set shown in Table 1. Data set
\sQuote{\code{ex_data_JoBS}} from package \sQuote{\code{T2EQ}}.
}
\usage{
data(dip3)
}
\description{
A data set containing the dissolution data of one reference batch and one
  test batch of \eqn{n = 12} capsules each, i.e. the dissolution profiles
  of the \% drug release observed at 15, 20 and 25 minutes.
}
\examples{
str(dip3)

if (requireNamespace("T2EQ")) {
library(T2EQ)

  data(ex_data_JoBS, envir = environment())
  str(ex_data_JoBS)
  rm(ex_data_JoBS)
}
}
\references{
Hoffelder, T., Goessl, R., and Wellek, S. Multivariate equivalence tests for
use in pharmaceutical development. \emph{J Biopharm Stat}. 2015;
\strong{25}(3): 417-437.\cr
\doi{10.1080/10543406.2014.920344}
}
\keyword{datasets}
