% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/disposition_effect.R
\name{disposition_effect}
\alias{disposition_effect}
\alias{disposition_difference}
\alias{disposition_compute}
\alias{disposition_compute_ts}
\alias{disposition_summary}
\alias{disposition_summary_ts}
\title{Disposition Effect}
\usage{
disposition_effect(realized_gains, paper_gains, realized_losses, paper_losses)

disposition_difference(gains, losses)

disposition_compute(
  gainslosses,
  dispdiff_value = FALSE,
  aggregate_fun = NULL,
  ...
)

disposition_compute_ts(gainslosses, aggregate_fun = NULL, ...)

disposition_summary(gainslosses, dispdiff_value = FALSE)

disposition_summary_ts(de_timeseries)
}
\arguments{
\item{realized_gains}{Numeric vector (or scalar) containing realized gains
values.}

\item{paper_gains}{Numeric vector (or scalar) containing paper gains
values.}

\item{realized_losses}{Numeric vector (or scalar) containing realized losses
values.}

\item{paper_losses}{Numeric vector (or scalar) containing paper losses
values.}

\item{gains}{Numeric vector (or scalar) containing gains.}

\item{losses}{Numeric vector (or scalar) containing losses.}

\item{gainslosses}{Data frame, the portfolio of the investor containing the
realized and paper gains and losses results (as those obtained via
\code{\link{portfolio_compute}}).}

\item{dispdiff_value}{Logical, if TRUE the disposition difference on the
"value" method is computed. Default to disposition effect (FALSE).}

\item{aggregate_fun}{Function to use to aggregate results.
Default to \code{NULL}, that is no aggregation is performed and the
results of each asset are shown.}

\item{...}{Further arguments to be passed to the aggregate function.}

\item{de_timeseries}{Data frame, the time series of disposition effects.}
}
\value{
Numeric vector (or scalar) with the value(s) of disposition
effect(s) or disposition difference(s).
}
\description{
Compute the disposition effect and the disposition
difference.
}
\details{
The disposition effect is defined as
\eqn{DE = (Realized Gain / (Realized Gain - Paper Gain)) -
       (Realized Loss / (Realized Loss + Paper Loss))}

The disposition difference is defined as
\eqn{DD = Realized Gain - |Realized Loss|}
or
\eqn{DD = Paper Gain - |Paper Loss|}
}
\section{Functions}{
\itemize{
\item \code{disposition_effect}: Compute the disposition effect

\item \code{disposition_difference}: Compute the disposition difference

\item \code{disposition_compute}: Compute the disposition effect directly on
the investor's portfolio containing realized and paper gains and losses
results.

\item \code{disposition_compute_ts}: Compute the time series disposition effect
on the gains and losses results.

\item \code{disposition_summary}: Wrapper that returns the most important
summary statistics related to the disposition effect.

\item \code{disposition_summary_ts}: Wrapper that returns the most important
summary statistics related to the time series disposition effect.
}}

