% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discrtr-package.R
\docType{data}
\name{mc_commute.csv}
\alias{mc_commute.csv}
\title{McMaster Commuting Data Set (csv file).}
\format{
An comma separated text file :
\describe{
\item{RespondentID}{Unique identifier for respondents}
\item{choice}{numeric variable indicating modes of transportation: (1) Cycle, (2) Walk, (3) HSR (local transit), (4) Car}
\item{avcycle}{Indicator variable for availability of cycling: (1) Yes, (0) No}
\item{avwalk}{Indicator variable for availability of walking: (1) Yes, (0) No}
\item{avhsr}{Indicator variable for availability of HSR: (1) Yes, (0) No}
\item{avcar}{Indicator variable for availability of car: (1) Yes, (0) No}
\item{timecycle}{Travel time by cycling in minutes (when mode not available coded as 100000)}
\item{timewalk}{Travel time by walking in minutes (when mode not available coded as 100000)}
\item{accesshsr}{Access time to HSR in minutes}
\item{waitingtimehsr}{Waiting time when travelling by HSR in minutes}
\item{transfer}{Number of transit transfers}
\item{timecar}{Travel time by car in minutes (when mode not available coded as 100000)}
\item{parking}{Indicator variable for holding a university parking permit: (1) Yes, (0) No}
\item{vehind}{Indicator variable for having individual access to a private car (i.e., car not shared with other household members): (1) Yes, (0) No}
\item{owncycle}{Indicator variable for owning a bicycle: (1) Yes, (0) No}
\item{gender}{Indicator variable for gender: (1) Woman, (0) Man}
\item{age}{Age in years}
\item{solo}{Indicator variable for living in solo accommodations: (1) Yes, (0) No}
\item{shared}{Indicator variable for a student living in a rental property with other students, i.e., shared accommodations: (1) Yes, (0) No}
\item{family}{Indicator variable for living in family home: (1) Yes, (0) No}
\item{child}{Indicator variable for presence of dependent minors in household: (1) Yes, (0) No}
\item{primary_caregiver}{Indicator variable for being the primary caregiver of dependent minors in household: (1) Yes, (0) No, (100000) No dependent minors in household}
\item{LAT}{Latitude of the place or residence, geocoded at the nearest major intersection or centroid of 6-digit postal area}
\item{LONG}{Longitude of the place or residence, geocoded at the nearest major intersection or centroid of 6-digit postal area}
\item{DAUID}{Unique ID of the dissemination area of place of residence according to the 2006 census of Canada}
\item{mhi}{Median household income of the dissemination area of place of residence according to the 2006 census of Canada}
\item{dwell_den}{Dwelling density in the dissemination area of the place of residence in $1/km^2$}
\item{lum}{Entropy of the land use mix}
\item{st_den}{Street density in the dissemination area of the place of residence in $km/km^2$}
\item{inter_den}{Intersection density in the dissemination area of the place of residence in $1/km^2$}
\item{SF_P_ratio}{Ratio of surface of plots to built area}
\item{side_density}{Sidewalk density in the dissemination area of the place of residence in $km/km^2$}
\item{Shelters_SD}{Response to statement "Shelters and other public transportation facilities that I commonly use are of good quality": 1 if Strongly Disagree, 0 otherwise}
\item{Shelters_D}{Response to statement "Shelters and other public transportation facilities that I commonly use are of good quality": 1 if Disagree, 0 otherwise}
\item{Shelters_A}{Response to statement "Shelters and other public transportation facilities that I commonly use are of good quality": 1 if Agree, 0 otherwise}
\item{Shelters_SA}{Response to statement "Shelters and other public transportation facilities that I commonly use are of good quality": 1 if Strongly Agree, 0 otherwise}
}
}
\source{
Whalen, K. E., P\'{a}ez, A., & Carrasco, J. A. (2013). Mode choice of university students commuting to school and the role of active travel. Journal of Transport Geography, 31, 132-142. (https://doi.org/10.1016/j.jtrangeo.2013.06.008)
}
\usage{
data(mc_commute_long)
}
\description{
A delimited text file containing information about \emph{students} commuting to McMaster University. Data were collected
by means of a travel survey in the fall of 2010. Respondents were asked about their mode of
travel to McMaster University, in Hamilton, Canada. They were also asked about the modes available
to them. The characteristics of the trips were self-reported or imputed. The data set also contains
relevant attributes about the respondents. The format of the table is long, with each row representing
a choice situation.
}
\examples{
 library(readr)
 mc_commute <- read_csv(system.file("extdata", "mc_commute.csv", package = "discrtr"))
}
\keyword{datasets}
