% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mod_afcm_utils.R
\name{e_afcmbi_3D}
\alias{e_afcmbi_3D}
\title{AFCM biplot in 3D}
\usage{
e_afcmbi_3D(
  modelo,
  axes = c(1, 2, 3),
  colorInd = "steelblue",
  colorVar = "forestgreen",
  cos2Ind = 0,
  cos2Var = 0,
  colorIndCos = "firebrick",
  colorVarCos = "darkorchid",
  titulos = c("Bien Representados", "Mal Representados"),
  etq = T
)
}
\arguments{
\item{modelo}{an object of class AFCM [FactoMineR].}

\item{axes}{a numeric vector of length 3 specifying the dimensions to be plotted.}

\item{colorInd}{a color for the individuals well represented.}

\item{colorVar}{a color for the variables well represented.}

\item{cos2Ind}{a numeric value from 0 to 1 specifying the quality of the individuals.}

\item{cos2Var}{a numeric value from 0 to 1 specifying the quality of the variables.}

\item{colorIndCos}{a color for individuals badly represented.}

\item{colorVarCos}{a color for variables badly represented.}

\item{titulos}{a character vector of length 2 specifying the titles to use on legend.}

\item{etq}{a boolean, whether to add label to graph or not.}
}
\value{
echarts4r plot
}
\description{
AFCM biplot in 3D
}
\examples{
data("poison", package = "FactoMineR")
poison.active <- poison[1:55, 5:15]
p <- FactoMineR::MCA(poison.active, graph = FALSE)
e_afcmbi_3D(p)

}
\author{
Diego Jimenez <diego.jimenez@promidat.com>
}
