% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filterBaseline.R
\name{filterBaseline}
\alias{filterBaseline}
\title{Filter the baseline signal for a given time window}
\usage{
filterBaseline(bl, filter.date.start, filter.date.end,
  date.format = "\%Y-\%m-\%d")
}
\arguments{
\item{bl}{baseline signal as returned from the function \code{prepareBaseline()}}

\item{filter.date.start}{start date of the filtering window}

\item{filter.date.end}{end date of the filtering window}

\item{date.format}{format of date specified in \code{filter.date.start} and \code{filter.date.end}}
}
\value{
baseline signal filtered for the given date window
}
\description{
Filter the baseline signal for a given time window
}
\examples{
# load sample data
data("sycamore")
x = sycamore

# get streamflow object for the sample data
x.streamflow = asStreamflow(x)

# baseline for single run for all the years in input signal
x.bl = prepareBaseline(x.streamflow)

# filter the baseline signal between years 1993 and 2000
x.bl.filtered = filterBaseline(x.bl, filter.date.start = "1993-01-01",
                               filter.date.end = "2000-12-31")

}
