% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DiscSurvEvaluationCR.R
\name{predErrCompRisks}
\alias{predErrCompRisks}
\title{Prediction Error Curves for Competing Risks}
\usage{
predErrCompRisks(
  testPreds,
  testDataShort,
  trainDataShort,
  timeColumn,
  eventColumns,
  tmax = NULL
)
}
\arguments{
\item{testPreds}{Predictions on the test data with model fitted on training data ("numeric matrix").
Predictions are stored in the rows and the number of columns equal the number of events.}

\item{testDataShort}{Test data in short format ("class data.frame").}

\item{trainDataShort}{Train data in short format ("class data.frame").}

\item{timeColumn}{Character giving the column name of the observed times("character vector").}

\item{eventColumns}{Character vector giving the column names of the event indicators (excluding censoring column) ("character vector").}

\item{tmax}{Gives the maximum time interval for which prediction errors are
calculated ("integer vector"). It must not be higher than the maximum observed time in the
training data.}
}
\value{
Calculated prediction errors for each competing event. Array with one matrix per competing event, 
with the predictions in the rows and the time points in the columns.
}
\description{
Estimates prediction error curves for discrete survival competing risks models
}
\examples{

###########################
# Example unemployment data
library(Ecdat)
data(UnempDur)

# Select subsample
selectInd1 <- 1:200
selectInd2 <- 201:400
trainSet <- UnempDur[which(UnempDur$spell \%in\% (1:10))[selectInd1], ]
testSet <- UnempDur[which(UnempDur$spell \%in\% (1:10))[selectInd2], ]

# Convert to long format 
trainSet_long <- dataLongCompRisks(dataShort=trainSet, timeColumn="spell", 
eventColumns=c("censor1", "censor4"), timeAsFactor=TRUE)
tmax          <- max(trainSet$spell)
testSet_long <- dataLongCompRisks(dataShort=testSet, timeColumn="spell", 
eventColumns=c("censor1", "censor4"), aggTimeFormat = TRUE, lastTheoInt=tmax,
timeAsFactor=TRUE)

# Estimate continuation ratio model with logit link
vglmFit <- VGAM::vglm(formula=cbind(e0, e1, e2) ~ timeInt + age + logwage, 
data=trainSet_long, family=VGAM::multinomial(refLevel="e0"))

# Calculate predicted hazards
predHazards <- VGAM::predictvglm(vglmFit, newdata=testSet_long, type="response")

# Compute prediction error 
predErrCompRisks(testPreds=predHazards[,-1], testSet, trainSet, "spell", 
c("censor1", "censor4"), tmax)


}
\references{
\insertRef{heyardValCompRisks}{discSurv}
}
\seealso{
\code{\link{intPredErrCompRisks}}, \code{\link{predErrCurve}}
}
\author{
Moritz Berger \email{moritz.berger@imbie.uni-bonn.de} \cr \url{https://www.imbie.uni-bonn.de/personen/dr-moritz-berger/}
}
\keyword{competing_risks}
\keyword{discrete_survival}
\keyword{prediction_error}
