% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DiscSurvDataTransform.R
\name{dataCensoring}
\alias{dataCensoring}
\title{Data Censoring Transformation for short formats}
\usage{
dataCensoring(dataShort, eventColumns, timeColumn, shortFormat = TRUE)
}
\arguments{
\item{dataShort}{Original data set in short format ("class data.frame").}

\item{eventColumns}{Name of event columns ("character vector"). The
event columns have to be in binary format. If the sum of all events equals
zero in a row, then this observation is interpreted as censored.}

\item{timeColumn}{Name of column with discrete time intervals ("character vector").}

\item{shortFormat}{Is the supplied data set \emph{dataShort} not preprocessed 
with function dataLong() ("logical vector")? Default is TRUE. If shortFormat=FALSE 
then it is assumed that the data set was augmented with function dataLong().}
}
\value{
Original data set as argument \emph{dataShort}, but with added censoring
process as first variable in column "yCens".
}
\description{
Function for transformation of discrete survival times in censoring
encoding. The original data is expanded to include the censoring process. 
Alternatively the long data format can also be augmented. With the new 
generated variable "yCens", the discrete censoring process can be analyzed 
instead of the discrete survival process. In discrete survival analysis this 
information is used to constructs weights for predictive evaluation measures. 
It is applicable in single event survival analysis.
}
\examples{

library(pec)
data(cost)
head(cost)
IntBorders <- 1:ceiling(max(cost$time)/30)*30
subCost <- cost [1:100, ]

# Convert from days to months
CostMonths <- contToDisc(dataShort=subCost, timeColumn="time", intervalLimits=IntBorders)
head(CostMonths)

# Generate censoring process variable in short format
CostMonthsCensorShort <- dataCensoring (dataShort = CostMonths, 
eventColumns = "status", timeColumn = "time", shortFormat = TRUE)
head(CostMonthsCensorShort)

################################
# Example with long data format
library(pec)
data(cost)
head(cost)
IntBorders <- 1:ceiling(max(cost$time)/30)*30
subCost <- cost [1:100, ]

# Convert from days to months
CostMonths <- contToDisc(dataShort = subCost, timeColumn = "time", intervalLimits = IntBorders)
head(CostMonths)

# Convert to long format based on months
CostMonthsLong <- dataLong(dataShort = CostMonths, timeColumn = "timeDisc", eventColumn = "status")
head(CostMonthsLong, 20)

# Generate censoring process variable
CostMonthsCensor <- dataCensoring (dataShort = CostMonthsLong, timeColumn = "timeInt", 
shortFormat = FALSE)
head(CostMonthsCensor)
tail(CostMonthsCensor [CostMonthsCensor$obj==1, ], 10)
tail(CostMonthsCensor [CostMonthsCensor$obj==3, ], 10)

}
\references{
\insertRef{tutzModelDisc}{discSurv} \cr\cr
\insertRef{fahrmeirDiscSurv}{discSurv} \cr\cr
\insertRef{thompsonTreatment}{discSurv}
}
\seealso{
\code{\link{contToDisc}},
\code{\link{dataLong}}, \code{\link{dataLongTimeDep}},
\code{\link{dataLongCompRisks}}
}
\author{
Thomas Welchowski \email{welchow@imbie.meb.uni-bonn.de}
}
\keyword{datagen}
