% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfpt.R
\name{dfpt}
\alias{dfpt}
\title{Discrete factor analysis with the truncated Poisson distribution}
\usage{
dfpt(y, A = NULL)
}
\arguments{
\item{y}{Data, an n by d numeric matrix}

\item{A}{truncation point (Note that if the data is in Likert scale
starting from 1, then you should subtract 1 from the data and then use the
proposed negative binomial models.}
}
\value{
A list with entries
\item{AIC}{AIC value for the optimal model}
\item{indexmat}{Factors and variables in each factor}
\item{estlambda}{Estimated parameters for factors}
\item{estmu}{Estimated parameters for each variable within each factor}
}
\description{
Discrete factor analysis with the truncated Poisson distribution
}
\examples{
dfpt(y = car_data[,1:5], A = 5)
}
